#pragma once
#include "Vector3.h"
#include <math.h>
#include <cmath>

class Camera
{
	public:
		Camera(float speed, Vector3 origin, Vector3 pitchYawRoll);	//Speed, initial position and initial pitch, yaw and roll
		~Camera();
		void Update();
		void Reset();
		void SetBounds(Vector3 minBounds, Vector3 maxBounds);	//Sets area camera can move in
		void SetOrigins(Vector3 origin, Vector3 pitchYawRoll);	//Sets where camera starts and should reset to

		//Virtual functions overridden for different camera types
		virtual void Animate(float dt);
		virtual void MoveForward(float dt);
		virtual void MoveRight(float dt);
		virtual void MoveUp(float dt);
		virtual void RotateX(float dt);
		virtual void RotateY(float dt);
		virtual void RotateZ(float dt);
		virtual void RotateFromMouse(float xOffset, float yOffset, float dt);

		//Getters
		Vector3 GetPosition();
		Vector3 GetLookAt();
		Vector3 GetUp();
		Vector3 GetPitchYawRoll();
		/*Vector3 DebugGetForward();
		Vector3 DebugGetLookAt();
		Vector3 DebugGetRight();*/

	protected:
		enum Direction
		{
			North,
			East,
			South,
			West
		};

		//Position vectors
		Vector3 _ForwardVector;
		Vector3 _PositionVector;
		Vector3 _LookAtVector;
		Vector3 _UpVector;
		Vector3 _RightVector;

		//Speeds
		float _Speed;
		float _MouseRotationSpeed;

		//Axis values
		float _Yaw;
		float _Pitch;
		float _Roll;

		//Bounds
		Vector3 _MinimumBounds;
		Vector3 _MaximumBounds;
		Vector3 _OriginPosition;

		Vector3 _PitchYawRoll;

		void ResetToBounds();	//Resets camera back to its boundary if it tries to go past it
		bool IsFacing(Direction direction);	//Gets relative direction the camera is facing
		bool DebugDisableBounds = false;	//Ignore bounds for debugging purposes

};

